/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.das2.util.monitor.ProgressMonitor;

public class DiskUsageModel {
    Map<File, Long> dirUsage = new HashMap<File, Long>();
    private boolean ready = false;
    public static final String PROP_READY = "ready";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private boolean notLink(File f) {
        try {
            return f.getCanonicalFile().equals(f);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void search(File f, ProgressMonitor mon) {
        this.search(f, 0, mon);
    }

    public void search(File f, int depth, ProgressMonitor mon) {
        try {
            File nf;
            f = nf = f.getCanonicalFile();
        }
        catch (IOException nf) {
            // empty catch block
        }
        File[] kids = f.listFiles();
        if (kids == null) {
            return;
        }
        if (depth == 0) {
            mon.setTaskSize((long)kids.length);
            mon.started();
        }
        for (int i = 0; i < kids.length; ++i) {
            if (depth == 0) {
                mon.setTaskProgress((long)i);
            }
            mon.setProgressMessage("" + kids[i]);
            if (mon.isCancelled()) {
                this.dirUsage.remove(f);
                return;
            }
            if (kids[i].isDirectory() && this.notLink(kids[i])) {
                this.search(kids[i], depth + 1, mon);
            } else if (kids[i].isDirectory() && !this.notLink(kids[i])) {
                System.err.println("appears to be a link: " + kids[i]);
            }
            if (depth != 0) continue;
            this.propertyChangeSupport.firePropertyChange("readyFolderCount", 0, i);
        }
        if (depth == 0) {
            mon.finished();
        }
        try {
            long totalSizeKB = 0L;
            for (int i = 0; i < kids.length; ++i) {
                File fkids1 = kids[i];
                if (!this.notLink(fkids1)) {
                    totalSizeKB += 0L;
                    continue;
                }
                if (fkids1.isDirectory()) {
                    Long l = this.dirUsage.get(fkids1);
                    if (l == null) {
                        totalSizeKB += 0L;
                        continue;
                    }
                    totalSizeKB += l + 4L;
                    continue;
                }
                totalSizeKB = (long)((double)totalSizeKB + (double)fkids1.length() / 1000.0);
            }
            this.dirUsage.put(f, totalSizeKB);
        }
        catch (NullPointerException ex) {
            System.err.println("here NullPointerException in DiskUsageModel");
        }
    }

    public Long usage(File f) {
        try {
            File nf;
            f = nf = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.dirUsage.get(f);
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean newready) {
        boolean oldready = this.ready;
        this.ready = newready;
        this.propertyChangeSupport.firePropertyChange(PROP_READY, oldready, newready);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

